﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Shared;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelOutbound
{
    /// <summary>
    /// Connect to CRM step.
    /// </summary>
    public class ConnectToCrmStep : FilterBase<MakeCancelOutboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelOutboundStateObject state)
        {
            try
            {
                state.OrganizationServiceProxy = PipelineUtilities.ConnectToCrm(state.RequestMessage.OrganizationName, PipelineUtilities.CrmAuthenticationMode.Ad);
            }
            catch (Exception ex)
            {
                throw new Exception($"HealthShare Make Cancel Outbound ConnectToCrmStep Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}